import React, { useEffect, useState } from "react";
import { createNativeStackNavigator } from "@react-navigation/native-stack";
import Onboard from "../../screens/WelcomeScreen/Onboard/Onboard";
import useAuthCheck from "../../hooks/useAuthCheck";
import { checkInternet } from "./NavigationHelper/checkInternet";
import { appFirstLaunch } from "./NavigationHelper/appFirstLaunch";
import Login from "../Authentication/Login/Login";
import ForgetPassword from "../Authentication/ForgetPassword/ForgetPassword";
import DrawerStack from "./DrawerStack";
import ProductDetails from "../../screens/Home/FeaturedProducts/ProductDetails/ProductDetails";
import Vendor from "../../screens/Vendor/Vendor";
import VendorReviews from "../../screens/Vendor/VendorReviews/VendorReviews";
import FeatureDisplay from "../../screens/Home/FeatureDIsplay/FeatureDisplay";
import Setting from "../../screens/Profile/Setting/Setting";
import SelectLanguage from "../../screens/Profile/Setting/SelectLanguage";
import PrivateRoute from "./PrivateRoute/PrivateRoute";
import EditProfile from "../../screens/Profile/EditProfile/EditProfile";
import Address from "../../screens/Profile/Address/Address";
import AddNewAddress from "../../screens/Profile/Address/AddNewAddress/AddNewAddress";
import OrderHistory from "../../screens/Profile/OrderHistory/OrderHistory";
import OrderDetails from "../../screens/Profile/OrderHistory/OrderDetails/OrderDetails";
import MyReviews from "../../screens/Profile/MyReviews/MyReviews";
import MyRefund from "../../screens/Profile/MyRefund/MyRefund";
import RefundRequest from "../../screens/Profile/MyRefund/RefundRequest/RefundRequest";
import RefundList from "../../screens/Profile/MyRefund/RefundList/RefundList";
import RefundDetails from "../../screens/Profile/MyRefund/RefundList/RefundDetails/RefundDetails";
import OrderSummary from "../../screens/ShoppingCart/OrderSummary/OrderSummary";
import BillingInformation from "../../screens/ShoppingCart/BillingInformation/BillingInformation";
import SelectDeliveryAddress from "../../screens/Home/FeaturedProducts/ProductDetails/DeliveryOptions/SelectDeliveryAddress";
import OrderConfirmed from "../../screens/ShoppingCart/OrderConfirmed/OrderConfirmed";
import Reviews from "../../screens/Home/FeaturedProducts/ProductDetails/RatingAndReviews/Reviews/Reviews";
import ReviewImageGallery from "../../screens/Home/FeaturedProducts/ProductDetails/RatingAndReviews/ReviewImageGallery";
import PaymentView from "../../screens/Payment/PaymentView";
import FilterHome from "../../screens/Filter/FilterHome/FilterHome";
import FoundContent from "../../screens/Filter/FilterHome/FoundContent";
import WriteReviews from "../../screens/Home/FeaturedProducts/ProductDetails/RatingAndReviews/WriteReviews/WriteReviews";
import EditReview from "../../screens/Profile/EditReview/EditReview";
import TrackOrder from "../../screens/TrackOrder/TrackOrder";
import ResetPassword from "../Authentication/ResetPassword/ResetPassword";
import PasswordChanged from "../Authentication/PasswordChanged/PasswordChanged";
import Registration from "../Authentication/Registration/Registration";
import ConfirmEmail from "../Authentication/ConfirmEmail/ConfirmEmail";
import AccountCreated from "../Authentication/AccountCreated/AccountCreated";
import GuestBillingInformation from "../../screens/ShoppingCart/BillingInformation/GuestBillingInformation";
import GuestAddNewAddress from "../../screens/Profile/Address/AddNewAddress/GuestAddNewAddress";
import GuestOrderSummary from "../../screens/ShoppingCart/OrderSummary/GuestOrderSummary";
import { PRODUCT_DETAILS } from "./RouteNames";
import { I18nManager } from "react-native";
import DeleteAccount from "../../screens/Profile/Setting/DeleteAccount";

const Stack = createNativeStackNavigator();

const Welcome = () => {
    useAuthCheck();

    const [isFirstLaunch, setIsFirstLaunch] = useState(null);
    useEffect(() => {
        (async () => {
            let isMounted = true;
            if (isMounted) {
                const isFirst = await appFirstLaunch();
                setIsFirstLaunch(isFirst);
            }
            return () => (isMounted = false);
        })()
    }, []);

    const internetIsConnecter = checkInternet();
    useEffect(() => {
        const unsubscribe = internetIsConnecter();
        return () => unsubscribe();
    }, []);

    if (isFirstLaunch === null) {
        return null;
    }
    return (
        <Stack.Navigator
            screenOptions={{
                headerShown: false,
                animation: I18nManager.isRTL ? 'slide_from_left' : 'slide_from_right',
            }}
            initialRouteName={
                isFirstLaunch === true ? 'onboarding' : 'DrawerStack'
            }
        >
            <Stack.Screen name='onboarding' component={Onboard} />
            <Stack.Screen name='DrawerStack' component={DrawerStack} />
            <Stack.Screen name={PRODUCT_DETAILS} component={ProductDetails} />
            <Stack.Screen name='Vendor' component={Vendor} />
            <Stack.Screen name='Vendor Reviews' component={VendorReviews} />
            <Stack.Screen name='feature display' component={FeatureDisplay} />
            <Stack.Screen name='settings' component={Setting} />
            <Stack.Screen name='select language' component={SelectLanguage} />
            <Stack.Screen name='guest billing info' component={GuestBillingInformation} />
            <Stack.Screen name='guest add new address' component={GuestAddNewAddress} />
            <Stack.Screen name='guest order summary' component={GuestOrderSummary}/>

            <Stack.Screen name='edit profile'>
                {(props) => (
                    <PrivateRoute>
                        <EditProfile {...props} />
                    </PrivateRoute>
                )}
            </Stack.Screen>
            <Stack.Screen name='delete account'>
                {(props) => (
                    <PrivateRoute>
                        <DeleteAccount {...props} />
                    </PrivateRoute>
                )}
            </Stack.Screen>
            <Stack.Screen name='address book'>
                {(props) => (
                    <PrivateRoute>
                        <Address {...props} />
                    </PrivateRoute>
                )}
            </Stack.Screen>
            <Stack.Screen name='add new address'>
                {(props) => (
                    <PrivateRoute>
                        <AddNewAddress {...props} />
                    </PrivateRoute>
                )}
            </Stack.Screen>
            <Stack.Screen name='order history'>
                {(props) => (
                    <PrivateRoute>
                        <OrderHistory {...props} />
                    </PrivateRoute>
                )}
            </Stack.Screen>
            <Stack.Screen name='order details'>
                {(props) => (
                    <PrivateRoute>
                        <OrderDetails {...props} />
                    </PrivateRoute>
                )}
            </Stack.Screen>
            <Stack.Screen name='my reviews'>
                {(props) => (
                    <PrivateRoute>
                        <MyReviews {...props} />
                    </PrivateRoute>
                )}
            </Stack.Screen>
            <Stack.Screen name='my refund'>
                {(props) => (
                    <PrivateRoute>
                        <MyRefund {...props} />
                    </PrivateRoute>
                )}
            </Stack.Screen>
            <Stack.Screen name='refund'>
                {(props) => (
                    <PrivateRoute>
                        <RefundRequest {...props} />
                    </PrivateRoute>
                )}
            </Stack.Screen>
            <Stack.Screen name='refund list'>
                {(props) => (
                    <PrivateRoute>
                        <RefundList {...props} />
                    </PrivateRoute>
                )}
            </Stack.Screen>
            <Stack.Screen name='refund details'>
                {(props) => (
                    <PrivateRoute>
                        <RefundDetails {...props} />
                    </PrivateRoute>
                )}
            </Stack.Screen>
            <Stack.Screen name='order summary'>
                {(props) => (
                    <PrivateRoute>
                        <OrderSummary {...props} />
                    </PrivateRoute>
                )}
            </Stack.Screen>
            <Stack.Screen name='billing info'>
                {(props) => (
                    <PrivateRoute>
                        <BillingInformation {...props} />
                    </PrivateRoute>
                )}
            </Stack.Screen>
            <Stack.Screen name='select delivery address'>
                {(props) => (
                    <PrivateRoute>
                        <SelectDeliveryAddress {...props} />
                    </PrivateRoute>
                )}
            </Stack.Screen>
            <Stack.Screen name='order done' component={OrderConfirmed} />
            <Stack.Screen name='reviews' component={Reviews} />
            <Stack.Screen
                name='reviewImageGallery'
                component={ReviewImageGallery}
            />
            <Stack.Screen name='payment webview' component={PaymentView} />
            <Stack.Screen
                name='filter home'
                component={FilterHome}
            />
            <Stack.Screen
                name='foundContent'
                component={FoundContent}
            />
            <Stack.Screen name='Write a Review'>
                {(props) => (
                    <PrivateRoute>
                        <WriteReviews {...props} />
                    </PrivateRoute>
                )}
            </Stack.Screen>
            <Stack.Screen name='Edit Review'>
                {(props) => (
                    <PrivateRoute>
                        <EditReview {...props} />
                    </PrivateRoute>
                )}
            </Stack.Screen>
            <Stack.Screen name='track order' component={TrackOrder} />
            <Stack.Screen name='login' component={Login} />
            <Stack.Screen name='Forget Password' component={ForgetPassword} />
            <Stack.Screen name='Reset Password' component={ResetPassword} />
            <Stack.Screen
                name='Password Reset Done'
                component={PasswordChanged}
            />

            <Stack.Screen name='registration' component={Registration} />
            <Stack.Screen name='Confirm Email' component={ConfirmEmail} />
            <Stack.Screen name='Account Created' component={AccountCreated} />
        </Stack.Navigator>
    );
};

export default Welcome;
